/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantNameAndType
extends Constant {
    private int nameIndex;
    private int signatureIndex;

    public ConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this(constantNameAndType.getNameIndex(), constantNameAndType.getSignatureIndex());
    }

    ConstantNameAndType(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public ConstantNameAndType(int n, int n2) {
        super((byte)12);
        this.nameIndex = n;
        this.signatureIndex = n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantNameAndType(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.signatureIndex);
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public String getName(ConstantPool constantPool) {
        return constantPool.constantToString(this.getNameIndex(), (byte)1);
    }

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public String getSignature(ConstantPool constantPool) {
        return constantPool.constantToString(this.getSignatureIndex(), (byte)1);
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public void setSignatureIndex(int n) {
        this.signatureIndex = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(nameIndex = " + this.nameIndex + ", signatureIndex = " + this.signatureIndex + ")";
    }
}

