/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleExports
implements Cloneable,
Node {
    private final int exportsIndex;
    private final int exportsFlags;
    private final int exportsToCount;
    private final int[] exportsToIndex;

    ModuleExports(DataInput dataInput) throws IOException {
        this.exportsIndex = dataInput.readUnsignedShort();
        this.exportsFlags = dataInput.readUnsignedShort();
        this.exportsToCount = dataInput.readUnsignedShort();
        this.exportsToIndex = new int[this.exportsToCount];
        for (int i = 0; i < this.exportsToCount; ++i) {
            this.exportsToIndex[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleExports(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.exportsIndex);
        dataOutputStream.writeShort(this.exportsFlags);
        dataOutputStream.writeShort(this.exportsToCount);
        for (int n : this.exportsToIndex) {
            dataOutputStream.writeShort(n);
        }
    }

    public String toString() {
        return "exports(" + this.exportsIndex + ", " + this.exportsFlags + ", " + this.exportsToCount + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.exportsIndex, (byte)20);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", ").append(String.format("%04x", this.exportsFlags));
        stringBuilder.append(", to(").append(this.exportsToCount).append("):\n");
        for (int n : this.exportsToIndex) {
            String string2 = constantPool.getConstantString(n, (byte)19);
            stringBuilder.append("      ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public ModuleExports copy() {
        try {
            return (ModuleExports)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

