/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AnnotationElementValue;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.ArrayElementValue;
import com.sun.org.apache.bcel.internal.classfile.ClassElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.EnumElementValue;
import com.sun.org.apache.bcel.internal.classfile.SimpleElementValue;
import com.sun.org.apache.bcel.internal.generic.AnnotationElementValueGen;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.ArrayElementValueGen;
import com.sun.org.apache.bcel.internal.generic.ClassElementValueGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.EnumElementValueGen;
import com.sun.org.apache.bcel.internal.generic.SimpleElementValueGen;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ElementValueGen {
    private final int type;
    private final ConstantPoolGen cpGen;
    public static final int STRING = 115;
    public static final int ENUM_CONSTANT = 101;
    public static final int CLASS = 99;
    public static final int ANNOTATION = 64;
    public static final int ARRAY = 91;
    public static final int PRIMITIVE_INT = 73;
    public static final int PRIMITIVE_BYTE = 66;
    public static final int PRIMITIVE_CHAR = 67;
    public static final int PRIMITIVE_DOUBLE = 68;
    public static final int PRIMITIVE_FLOAT = 70;
    public static final int PRIMITIVE_LONG = 74;
    public static final int PRIMITIVE_SHORT = 83;
    public static final int PRIMITIVE_BOOLEAN = 90;

    protected ElementValueGen(int n, ConstantPoolGen constantPoolGen) {
        this.type = n;
        this.cpGen = constantPoolGen;
    }

    public abstract ElementValue getElementValue();

    public int getElementValueType() {
        return this.type;
    }

    public abstract String stringifyValue();

    public abstract void dump(DataOutputStream var1) throws IOException;

    public static ElementValueGen readElementValue(DataInput dataInput, ConstantPoolGen constantPoolGen) throws IOException {
        int n = dataInput.readUnsignedByte();
        switch (n) {
            case 66: {
                return new SimpleElementValueGen(66, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 67: {
                return new SimpleElementValueGen(67, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 68: {
                return new SimpleElementValueGen(68, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 70: {
                return new SimpleElementValueGen(70, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 73: {
                return new SimpleElementValueGen(73, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 74: {
                return new SimpleElementValueGen(74, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 83: {
                return new SimpleElementValueGen(83, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 90: {
                return new SimpleElementValueGen(90, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 115: {
                return new SimpleElementValueGen(115, dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 101: {
                return new EnumElementValueGen(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 99: {
                return new ClassElementValueGen(dataInput.readUnsignedShort(), constantPoolGen);
            }
            case 64: {
                return new AnnotationElementValueGen(64, new AnnotationEntryGen(AnnotationEntry.read(dataInput, constantPoolGen.getConstantPool(), true), constantPoolGen, false), constantPoolGen);
            }
            case 91: {
                int n2 = dataInput.readUnsignedShort();
                ElementValue[] elementValueArray = new ElementValue[n2];
                for (int i = 0; i < n2; ++i) {
                    elementValueArray[i] = ElementValue.readElementValue(dataInput, constantPoolGen.getConstantPool());
                }
                return new ArrayElementValueGen(91, elementValueArray, constantPoolGen);
            }
        }
        throw new IllegalArgumentException("Unexpected element value kind in annotation: " + n);
    }

    protected ConstantPoolGen getConstantPool() {
        return this.cpGen;
    }

    public static ElementValueGen copy(ElementValue elementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        switch (elementValue.getElementValueType()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValueGen((SimpleElementValue)elementValue, constantPoolGen, bl);
            }
            case 101: {
                return new EnumElementValueGen((EnumElementValue)elementValue, constantPoolGen, bl);
            }
            case 64: {
                return new AnnotationElementValueGen((AnnotationElementValue)elementValue, constantPoolGen, bl);
            }
            case 91: {
                return new ArrayElementValueGen((ArrayElementValue)elementValue, constantPoolGen, bl);
            }
            case 99: {
                return new ClassElementValueGen((ClassElementValue)elementValue, constantPoolGen, bl);
            }
        }
        throw new UnsupportedOperationException("Not implemented yet! (" + elementValue.getElementValueType() + ")");
    }
}

