/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.stream;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.istack.internal.XMLStreamReaderToContentHandler;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.StreamingSOAP;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.message.stream.StreamHeader11;
import com.sun.xml.internal.ws.message.stream.StreamHeader12;
import com.sun.xml.internal.ws.protocol.soap.VersionMismatchException;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.xml.DummyLocation;
import com.sun.xml.internal.ws.util.xml.StAXSource;
import com.sun.xml.internal.ws.util.xml.XMLReaderComposite;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

public class StreamMessage
extends AbstractMessageImpl
implements StreamingSOAP {
    @NotNull
    private XMLStreamReader reader;
    @Nullable
    private MessageHeaders headers;
    private String bodyPrologue = null;
    private String bodyEpilogue = null;
    private String payloadLocalName;
    private String payloadNamespaceURI;
    private Throwable consumedAt;
    private XMLStreamReader envelopeReader;
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    static final StreamHeaderDecoder SOAP12StreamHeaderDecoder = new StreamHeaderDecoder(){

        @Override
        public Header decodeHeader(XMLStreamReader xMLStreamReader, XMLStreamBuffer xMLStreamBuffer) {
            return new StreamHeader12(xMLStreamReader, xMLStreamBuffer);
        }
    };
    static final StreamHeaderDecoder SOAP11StreamHeaderDecoder = new StreamHeaderDecoder(){

        @Override
        public Header decodeHeader(XMLStreamReader xMLStreamReader, XMLStreamBuffer xMLStreamBuffer) {
            return new StreamHeader11(xMLStreamReader, xMLStreamBuffer);
        }
    };

    public StreamMessage(SOAPVersion sOAPVersion) {
        super(sOAPVersion);
        this.payloadLocalName = null;
        this.payloadNamespaceURI = null;
    }

    public StreamMessage(SOAPVersion sOAPVersion, @NotNull XMLStreamReader xMLStreamReader, @NotNull AttachmentSet attachmentSet) {
        super(sOAPVersion);
        this.envelopeReader = xMLStreamReader;
        this.attachmentSet = attachmentSet;
    }

    @Override
    public XMLStreamReader readEnvelope() {
        if (this.envelopeReader == null) {
            XMLStreamReader[] xMLStreamReaderArray;
            ArrayList<XMLStreamReader> arrayList = new ArrayList<XMLStreamReader>();
            XMLReaderComposite.ElemInfo elemInfo = new XMLReaderComposite.ElemInfo(this.envelopeTag, null);
            XMLReaderComposite.ElemInfo elemInfo2 = this.headerTag != null ? new XMLReaderComposite.ElemInfo(this.headerTag, elemInfo) : null;
            XMLReaderComposite.ElemInfo elemInfo3 = new XMLReaderComposite.ElemInfo(this.bodyTag, elemInfo);
            for (Header xMLStreamReaderArray22 : this.getHeaders().asList()) {
                try {
                    arrayList.add(xMLStreamReaderArray22.readHeader());
                }
                catch (XMLStreamException xMLReaderComposite2) {
                    throw new RuntimeException(xMLReaderComposite2);
                }
            }
            XMLReaderComposite xMLReaderComposite = elemInfo2 != null ? new XMLReaderComposite(elemInfo2, arrayList.toArray(new XMLStreamReader[arrayList.size()])) : null;
            XMLStreamReader[] xMLStreamReaderArray2 = new XMLStreamReader[]{this.readPayload()};
            XMLReaderComposite xMLReaderComposite2 = new XMLReaderComposite(elemInfo3, xMLStreamReaderArray2);
            if (xMLReaderComposite != null) {
                XMLStreamReader[] xMLStreamReaderArray3 = new XMLStreamReader[2];
                xMLStreamReaderArray3[0] = xMLReaderComposite;
                xMLStreamReaderArray = xMLStreamReaderArray3;
                xMLStreamReaderArray3[1] = xMLReaderComposite2;
            } else {
                XMLStreamReader[] xMLStreamReaderArray4 = new XMLStreamReader[1];
                xMLStreamReaderArray = xMLStreamReaderArray4;
                xMLStreamReaderArray4[0] = xMLReaderComposite2;
            }
            XMLStreamReader[] xMLStreamReaderArray5 = xMLStreamReaderArray;
            return new XMLReaderComposite(elemInfo, xMLStreamReaderArray5);
        }
        return this.envelopeReader;
    }

    public StreamMessage(@Nullable MessageHeaders messageHeaders, @NotNull AttachmentSet attachmentSet, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        super(sOAPVersion);
        this.init(messageHeaders, attachmentSet, xMLStreamReader, sOAPVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(@Nullable MessageHeaders messageHeaders, @NotNull AttachmentSet attachmentSet, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        this.headers = messageHeaders;
        this.attachmentSet = attachmentSet;
        this.reader = xMLStreamReader;
        if (xMLStreamReader.getEventType() == 7) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        if (xMLStreamReader.getEventType() == 2) {
            String string = xMLStreamReader.getLocalName();
            String string2 = xMLStreamReader.getNamespaceURI();
            assert (string != null);
            assert (string2 != null);
            if (!string.equals(SOAP_BODY) || !string2.equals(sOAPVersion.nsUri)) throw new WebServiceException("Malformed stream: {" + string2 + "}" + string);
            this.payloadLocalName = null;
            this.payloadNamespaceURI = null;
        } else {
            this.payloadLocalName = xMLStreamReader.getLocalName();
            this.payloadNamespaceURI = xMLStreamReader.getNamespaceURI();
        }
        int n = sOAPVersion.ordinal() * 3;
        this.envelopeTag = (TagInfoset)DEFAULT_TAGS.get(n);
        this.headerTag = (TagInfoset)DEFAULT_TAGS.get(n + 1);
        this.bodyTag = (TagInfoset)DEFAULT_TAGS.get(n + 2);
    }

    public StreamMessage(@NotNull TagInfoset tagInfoset, @Nullable TagInfoset tagInfoset2, @NotNull AttachmentSet attachmentSet, @Nullable MessageHeaders messageHeaders, @NotNull TagInfoset tagInfoset3, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        this(tagInfoset, tagInfoset2, attachmentSet, messageHeaders, null, tagInfoset3, null, xMLStreamReader, sOAPVersion);
    }

    public StreamMessage(@NotNull TagInfoset tagInfoset, @Nullable TagInfoset tagInfoset2, @NotNull AttachmentSet attachmentSet, @Nullable MessageHeaders messageHeaders, @Nullable String string, @NotNull TagInfoset tagInfoset3, @Nullable String string2, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        super(sOAPVersion);
        this.init(tagInfoset, tagInfoset2, attachmentSet, messageHeaders, string, tagInfoset3, string2, xMLStreamReader, sOAPVersion);
    }

    private void init(@NotNull TagInfoset tagInfoset, @Nullable TagInfoset tagInfoset2, @NotNull AttachmentSet attachmentSet, @Nullable MessageHeaders messageHeaders, @Nullable String string, @NotNull TagInfoset tagInfoset3, @Nullable String string2, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        this.init(messageHeaders, attachmentSet, xMLStreamReader, sOAPVersion);
        if (tagInfoset == null) {
            throw new IllegalArgumentException("EnvelopeTag TagInfoset cannot be null");
        }
        if (tagInfoset3 == null) {
            throw new IllegalArgumentException("BodyTag TagInfoset cannot be null");
        }
        this.envelopeTag = tagInfoset;
        this.headerTag = tagInfoset2;
        this.bodyTag = tagInfoset3;
        this.bodyPrologue = string;
        this.bodyEpilogue = string2;
    }

    @Override
    public boolean hasHeaders() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        return this.headers != null && this.headers.hasHeaders();
    }

    @Override
    public MessageHeaders getHeaders() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        if (this.headers == null) {
            this.headers = new HeaderList(this.getSOAPVersion());
        }
        return this.headers;
    }

    @Override
    public String getPayloadLocalPart() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        return this.payloadNamespaceURI;
    }

    @Override
    public boolean hasPayload() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        return this.payloadLocalName != null;
    }

    @Override
    public Source readPayloadAsSource() {
        if (this.hasPayload()) {
            assert (this.unconsumed());
            return new StAXSource(this.reader, true, this.getInscopeNamespaces());
        }
        return null;
    }

    private String[] getInscopeNamespaces() {
        int n;
        NamespaceSupport namespaceSupport = new NamespaceSupport();
        namespaceSupport.pushContext();
        for (n = 0; n < this.envelopeTag.ns.length; n += 2) {
            namespaceSupport.declarePrefix(this.envelopeTag.ns[n], this.envelopeTag.ns[n + 1]);
        }
        namespaceSupport.pushContext();
        for (n = 0; n < this.bodyTag.ns.length; n += 2) {
            namespaceSupport.declarePrefix(this.bodyTag.ns[n], this.bodyTag.ns[n + 1]);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = namespaceSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string);
            arrayList.add(namespaceSupport.getURI(string));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Object readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.reader);
            return object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
            XMLStreamReaderUtil.readRest(this.reader);
            XMLStreamReaderUtil.close(this.reader);
            XMLStreamReaderFactory.recycle(this.reader);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        T t = bridge.unmarshal(this.reader, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
        return t;
    }

    @Override
    public <T> T readPayloadAsJAXB(XMLBridge<T> xMLBridge) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        T t = xMLBridge.unmarshal(this.reader, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
        return t;
    }

    @Override
    public void consume() {
        assert (this.unconsumed());
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public XMLStreamReader readPayload() {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        return this.reader;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        assert (this.unconsumed());
        if (this.payloadLocalName == null) {
            return;
        }
        if (this.bodyPrologue != null) {
            xMLStreamWriter.writeCharacters(this.bodyPrologue);
        }
        XMLStreamReaderToXMLStreamWriter xMLStreamReaderToXMLStreamWriter = new XMLStreamReaderToXMLStreamWriter();
        while (this.reader.getEventType() != 8) {
            String string = this.reader.getLocalName();
            String string2 = this.reader.getNamespaceURI();
            if (this.reader.getEventType() == 2) {
                if (this.isBodyElement(string, string2)) break;
                String string3 = XMLStreamReaderUtil.nextWhiteSpaceContent(this.reader);
                if (string3 == null) continue;
                this.bodyEpilogue = string3;
                xMLStreamWriter.writeCharacters(string3);
                continue;
            }
            xMLStreamReaderToXMLStreamWriter.bridge(this.reader, xMLStreamWriter);
        }
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
    }

    private boolean isBodyElement(String string, String string2) {
        return string.equals(SOAP_BODY) && string2.equals(this.soapVersion.nsUri);
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        this.writeEnvelope(xMLStreamWriter);
    }

    private void writeEnvelope(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        xMLStreamWriter.writeStartDocument();
        this.envelopeTag.writeStart(xMLStreamWriter);
        MessageHeaders messageHeaders = this.getHeaders();
        if (messageHeaders.hasHeaders() && this.headerTag == null) {
            this.headerTag = new TagInfoset(this.envelopeTag.nsUri, SOAP_HEADER, this.envelopeTag.prefix, EMPTY_ATTS, new String[0]);
        }
        if (this.headerTag != null) {
            this.headerTag.writeStart(xMLStreamWriter);
            if (messageHeaders.hasHeaders()) {
                for (Header header : messageHeaders.asList()) {
                    header.writeTo(xMLStreamWriter);
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        this.bodyTag.writeStart(xMLStreamWriter);
        if (this.hasPayload()) {
            this.writePayloadTo(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    @Override
    public void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        assert (this.unconsumed());
        try {
            Object object;
            if (this.payloadLocalName == null) {
                return;
            }
            if (this.bodyPrologue != null) {
                object = this.bodyPrologue.toCharArray();
                contentHandler.characters((char[])object, 0, ((char[])object).length);
            }
            object = new XMLStreamReaderToContentHandler(this.reader, contentHandler, true, bl, this.getInscopeNamespaces());
            while (this.reader.getEventType() != 8) {
                String string = this.reader.getLocalName();
                String string2 = this.reader.getNamespaceURI();
                if (this.reader.getEventType() == 2) {
                    if (this.isBodyElement(string, string2)) break;
                    String string3 = XMLStreamReaderUtil.nextWhiteSpaceContent(this.reader);
                    if (string3 == null) continue;
                    this.bodyEpilogue = string3;
                    char[] cArray = string3.toCharArray();
                    contentHandler.characters(cArray, 0, cArray.length);
                    continue;
                }
                ((XMLStreamReaderToContentHandler)object).bridge();
            }
            XMLStreamReaderUtil.readRest(this.reader);
            XMLStreamReaderUtil.close(this.reader);
            XMLStreamReaderFactory.recycle(this.reader);
        }
        catch (XMLStreamException xMLStreamException) {
            Location location = xMLStreamException.getLocation();
            if (location == null) {
                location = DummyLocation.INSTANCE;
            }
            SAXParseException sAXParseException = new SAXParseException(xMLStreamException.getMessage(), location.getPublicId(), location.getSystemId(), location.getLineNumber(), location.getColumnNumber(), xMLStreamException);
            errorHandler.error(sAXParseException);
        }
    }

    @Override
    public Message copy() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        try {
            Object object;
            assert (this.unconsumed());
            this.consumedAt = null;
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            StreamReaderBufferCreator streamReaderBufferCreator = new StreamReaderBufferCreator(mutableXMLStreamBuffer);
            streamReaderBufferCreator.storeElement(this.envelopeTag.nsUri, this.envelopeTag.localName, this.envelopeTag.prefix, this.envelopeTag.ns);
            streamReaderBufferCreator.storeElement(this.bodyTag.nsUri, this.bodyTag.localName, this.bodyTag.prefix, this.bodyTag.ns);
            if (this.hasPayload()) {
                String string;
                while (this.reader.getEventType() != 8 && !this.isBodyElement((String)(object = this.reader.getLocalName()), string = this.reader.getNamespaceURI()) && this.reader.getEventType() != 8) {
                    streamReaderBufferCreator.create(this.reader);
                    if (this.reader.isWhiteSpace()) {
                        this.bodyEpilogue = XMLStreamReaderUtil.currentWhiteSpaceContent(this.reader);
                        continue;
                    }
                    this.bodyEpilogue = null;
                }
            }
            streamReaderBufferCreator.storeEndElement();
            streamReaderBufferCreator.storeEndElement();
            streamReaderBufferCreator.storeEndElement();
            XMLStreamReaderUtil.readRest(this.reader);
            XMLStreamReaderUtil.close(this.reader);
            XMLStreamReaderFactory.recycle(this.reader);
            this.reader = mutableXMLStreamBuffer.readAsXMLStreamReader();
            object = mutableXMLStreamBuffer.readAsXMLStreamReader();
            this.proceedToRootElement(this.reader);
            this.proceedToRootElement((XMLStreamReader)object);
            return new StreamMessage(this.envelopeTag, this.headerTag, this.attachmentSet, HeaderList.copy(this.headers), this.bodyPrologue, this.bodyTag, this.bodyEpilogue, (XMLStreamReader)object, this.soapVersion);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException("Failed to copy a message", xMLStreamException);
        }
    }

    private void proceedToRootElement(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        assert (xMLStreamReader.getEventType() == 7);
        xMLStreamReader.nextTag();
        xMLStreamReader.nextTag();
        xMLStreamReader.nextTag();
        assert (xMLStreamReader.getEventType() == 1 || xMLStreamReader.getEventType() == 2);
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        this.envelopeTag.writeStart(contentHandler);
        if (this.hasHeaders() && this.headerTag == null) {
            this.headerTag = new TagInfoset(this.envelopeTag.nsUri, SOAP_HEADER, this.envelopeTag.prefix, EMPTY_ATTS, new String[0]);
        }
        if (this.headerTag != null) {
            this.headerTag.writeStart(contentHandler);
            if (this.hasHeaders()) {
                MessageHeaders messageHeaders = this.getHeaders();
                for (Header header : messageHeaders.asList()) {
                    header.writeTo(contentHandler, errorHandler);
                }
            }
            this.headerTag.writeEnd(contentHandler);
        }
        this.bodyTag.writeStart(contentHandler);
        this.writePayloadTo(contentHandler, errorHandler, true);
        this.bodyTag.writeEnd(contentHandler);
        this.envelopeTag.writeEnd(contentHandler);
        contentHandler.endDocument();
    }

    private boolean unconsumed() {
        if (this.payloadLocalName == null) {
            return true;
        }
        if (this.reader.getEventType() != 1) {
            AssertionError assertionError = new AssertionError((Object)"StreamMessage has been already consumed. See the nested exception for where it's consumed");
            ((Throwable)((Object)assertionError)).initCause(this.consumedAt);
            throw assertionError;
        }
        this.consumedAt = new Exception().fillInStackTrace();
        return true;
    }

    public String getBodyPrologue() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        return this.bodyPrologue;
    }

    public String getBodyEpilogue() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        return this.bodyEpilogue;
    }

    public XMLStreamReader getReader() {
        if (this.envelopeReader != null) {
            StreamMessage.readEnvelope(this);
        }
        assert (this.unconsumed());
        return this.reader;
    }

    private static void readEnvelope(StreamMessage streamMessage) {
        if (streamMessage.envelopeReader == null) {
            return;
        }
        XMLStreamReader xMLStreamReader = streamMessage.envelopeReader;
        streamMessage.envelopeReader = null;
        SOAPVersion sOAPVersion = streamMessage.soapVersion;
        if (xMLStreamReader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (SOAP_ENVELOPE.equals(xMLStreamReader.getLocalName()) && !sOAPVersion.nsUri.equals(xMLStreamReader.getNamespaceURI())) {
            throw new VersionMismatchException(sOAPVersion, sOAPVersion.nsUri, xMLStreamReader.getNamespaceURI());
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, sOAPVersion.nsUri, SOAP_ENVELOPE);
        TagInfoset tagInfoset = new TagInfoset(xMLStreamReader);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
            hashMap.put(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
        }
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        HeaderList headerList = null;
        TagInfoset tagInfoset2 = null;
        if (xMLStreamReader.getLocalName().equals(SOAP_HEADER) && xMLStreamReader.getNamespaceURI().equals(sOAPVersion.nsUri)) {
            tagInfoset2 = new TagInfoset(xMLStreamReader);
            for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
                hashMap.put(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
            }
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            if (xMLStreamReader.getEventType() == 1) {
                headerList = new HeaderList(sOAPVersion);
                try {
                    StreamHeaderDecoder streamHeaderDecoder = SOAPVersion.SOAP_11.equals((Object)sOAPVersion) ? SOAP11StreamHeaderDecoder : SOAP12StreamHeaderDecoder;
                    StreamMessage.cacheHeaders(xMLStreamReader, hashMap, headerList, streamHeaderDecoder);
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
            }
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, sOAPVersion.nsUri, SOAP_BODY);
        TagInfoset tagInfoset3 = new TagInfoset(xMLStreamReader);
        String string = XMLStreamReaderUtil.nextWhiteSpaceContent(xMLStreamReader);
        streamMessage.init(tagInfoset, tagInfoset2, streamMessage.attachmentSet, headerList, string, tagInfoset3, null, xMLStreamReader, sOAPVersion);
    }

    private static XMLStreamBuffer cacheHeaders(XMLStreamReader xMLStreamReader, Map<String, String> map, HeaderList headerList, StreamHeaderDecoder streamHeaderDecoder) throws XMLStreamException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = StreamMessage.createXMLStreamBuffer();
        StreamReaderBufferCreator streamReaderBufferCreator = new StreamReaderBufferCreator();
        streamReaderBufferCreator.setXMLStreamBuffer(mutableXMLStreamBuffer);
        while (xMLStreamReader.getEventType() == 1) {
            Map<String, String> map2 = map;
            if (xMLStreamReader.getNamespaceCount() > 0) {
                map2 = new HashMap<String, String>(map);
                for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
                    map2.put(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
                }
            }
            XMLStreamBufferMark xMLStreamBufferMark = new XMLStreamBufferMark(map2, streamReaderBufferCreator);
            headerList.add(streamHeaderDecoder.decodeHeader(xMLStreamReader, xMLStreamBufferMark));
            streamReaderBufferCreator.createElementFragment(xMLStreamReader, false);
            if (xMLStreamReader.getEventType() == 1 || xMLStreamReader.getEventType() == 2) continue;
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        return mutableXMLStreamBuffer;
    }

    private static MutableXMLStreamBuffer createXMLStreamBuffer() {
        return new MutableXMLStreamBuffer();
    }

    protected static interface StreamHeaderDecoder {
        public Header decodeHeader(XMLStreamReader var1, XMLStreamBuffer var2);
    }
}

