/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import com.sun.org.apache.xerces.internal.util.SecurityManager;
import java.util.concurrent.CopyOnWriteArrayList;
import jdk.xml.internal.SecuritySupport;
import jdk.xml.internal.XMLLimitAnalyzer;
import org.xml.sax.SAXException;

public final class XMLSecurityManager {
    private static final int NO_LIMIT = 0;
    private final int[] values = new int[Limit.values().length];
    private State[] states = new State[Limit.values().length];
    boolean secureProcessing;
    private boolean[] isSet = new boolean[Limit.values().length];
    private final int indexEntityCountInfo = 10000;
    private String printEntityCountInfo = "";
    private static final CopyOnWriteArrayList<String> printedWarnings = new CopyOnWriteArrayList();

    public XMLSecurityManager() {
        this(false);
    }

    public XMLSecurityManager(boolean bl) {
        this.secureProcessing = bl;
        for (Limit limit : Limit.values()) {
            if (bl) {
                this.values[limit.ordinal()] = limit.secureValue;
                this.states[limit.ordinal()] = State.FSP;
                continue;
            }
            this.values[limit.ordinal()] = limit.defaultValue();
            this.states[limit.ordinal()] = State.DEFAULT;
        }
        this.readSystemProperties();
    }

    public void setSecureProcessing(boolean bl) {
        this.secureProcessing = bl;
        for (Limit limit : Limit.values()) {
            if (bl) {
                this.setLimit(limit.ordinal(), State.FSP, limit.secureValue());
                continue;
            }
            this.setLimit(limit.ordinal(), State.FSP, limit.defaultValue());
        }
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public String find(String string) {
        for (Limit limit : Limit.values()) {
            if ((limit.systemProperty() == null || !limit.systemProperty().equals(string)) && !limit.apiProperty().equals(string)) continue;
            return limit.systemProperty();
        }
        if (string == null) {
            System.out.println("propertyName is null, returning null!");
            return null;
        }
        if (string.equals("http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo") || string.equals("jdk.xml.getEntityCountInfo")) {
            System.out.println("jdk.xml.getEntityCountInfo");
            return "jdk.xml.getEntityCountInfo";
        }
        System.out.println("Couldn't find the property, returning null!");
        return null;
    }

    public boolean setLimit(String string, State state, Object object) {
        int n = this.getIndex(string);
        if (n > -1) {
            this.setLimit(n, state, object);
            return true;
        }
        return false;
    }

    public void setLimit(Limit limit, State state, int n) {
        this.setLimit(limit.ordinal(), state, n);
    }

    public void setLimit(int n, State state, Object object) {
        if (n == 10000) {
            this.printEntityCountInfo = (String)object;
        } else {
            int n2;
            if (object instanceof Integer) {
                n2 = (Integer)object;
            } else {
                n2 = Integer.parseInt((String)object);
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            this.setLimit(n, state, n2);
        }
    }

    public void setLimit(int n, State state, int n2) {
        if (n == 10000) {
            this.printEntityCountInfo = "yes";
        } else if (state.compareTo(this.states[n]) >= 0) {
            this.values[n] = n2;
            this.states[n] = state;
            this.isSet[n] = true;
        }
    }

    public String getLimitAsString(String string) {
        int n = this.getIndex(string);
        if (n > -1) {
            return this.getLimitValueByIndex(n);
        }
        return null;
    }

    public int getLimit(Limit limit) {
        return this.values[limit.ordinal()];
    }

    public String getLimitValueAsString(Limit limit) {
        return Integer.toString(this.values[limit.ordinal()]);
    }

    public String getLimitValueByIndex(int n) {
        if (n == 10000) {
            return this.printEntityCountInfo;
        }
        return Integer.toString(this.values[n]);
    }

    public State getState(Limit limit) {
        return this.states[limit.ordinal()];
    }

    public String getStateLiteral(Limit limit) {
        return this.states[limit.ordinal()].literal();
    }

    public int getIndex(String string) {
        for (Limit limit : Limit.values()) {
            if (!limit.equalsAPIPropertyName(string)) continue;
            return limit.ordinal();
        }
        if (string.equals("http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo")) {
            return 10000;
        }
        return -1;
    }

    public boolean isNoLimit(int n) {
        return n == 0;
    }

    public boolean isOverLimit(Limit limit, String string, int n, XMLLimitAnalyzer xMLLimitAnalyzer) {
        return this.isOverLimit(limit.ordinal(), string, n, xMLLimitAnalyzer);
    }

    public boolean isOverLimit(int n, String string, int n2, XMLLimitAnalyzer xMLLimitAnalyzer) {
        if (this.values[n] == 0) {
            return false;
        }
        if (n2 > this.values[n]) {
            xMLLimitAnalyzer.addValue(n, string, n2);
            return true;
        }
        return false;
    }

    public boolean isOverLimit(Limit limit, XMLLimitAnalyzer xMLLimitAnalyzer) {
        return this.isOverLimit(limit.ordinal(), xMLLimitAnalyzer);
    }

    public boolean isOverLimit(int n, XMLLimitAnalyzer xMLLimitAnalyzer) {
        if (this.values[n] == 0) {
            return false;
        }
        if (n == Limit.ELEMENT_ATTRIBUTE_LIMIT.ordinal() || n == Limit.ENTITY_EXPANSION_LIMIT.ordinal() || n == Limit.TOTAL_ENTITY_SIZE_LIMIT.ordinal() || n == Limit.ENTITY_REPLACEMENT_LIMIT.ordinal() || n == Limit.MAX_ELEMENT_DEPTH_LIMIT.ordinal() || n == Limit.MAX_NAME_LIMIT.ordinal()) {
            return xMLLimitAnalyzer.getTotalValue(n) > this.values[n];
        }
        return xMLLimitAnalyzer.getValue(n) > this.values[n];
    }

    public void debugPrint(XMLLimitAnalyzer xMLLimitAnalyzer) {
        if (this.printEntityCountInfo.equals("yes")) {
            xMLLimitAnalyzer.debugPrint(this);
        }
    }

    public boolean isSet(int n) {
        return this.isSet[n];
    }

    public boolean printEntityCountInfo() {
        return this.printEntityCountInfo.equals("yes");
    }

    private void readSystemProperties() {
        for (Limit limit : Limit.values()) {
            if (this.getSystemProperty(limit, limit.systemProperty())) continue;
            for (NameMap nameMap : NameMap.values()) {
                String string = nameMap.getOldName(limit.systemProperty());
                if (string == null) continue;
                this.getSystemProperty(limit, string);
            }
        }
    }

    public static void printWarning(String string, String string2, SAXException sAXException) {
        String string3 = string + ":" + string2;
        if (printedWarnings.addIfAbsent(string3)) {
            System.err.println("Warning: " + string + ": " + sAXException.getMessage());
        }
    }

    private boolean getSystemProperty(Limit limit, String string) {
        try {
            String string2 = SecuritySupport.getSystemProperty(string);
            if (string2 != null && !string2.equals("")) {
                this.values[limit.ordinal()] = Integer.parseInt(string2);
                this.states[limit.ordinal()] = State.SYSTEMPROPERTY;
                return true;
            }
            string2 = SecuritySupport.readJAXPProperty(string);
            if (string2 != null && !string2.equals("")) {
                this.values[limit.ordinal()] = Integer.parseInt(string2);
                this.states[limit.ordinal()] = State.JAXPDOTPROPERTIES;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Invalid setting for system property: " + limit.systemProperty());
        }
        return false;
    }

    public static XMLSecurityManager convert(Object object, XMLSecurityManager xMLSecurityManager) {
        if (object == null) {
            if (xMLSecurityManager == null) {
                xMLSecurityManager = new XMLSecurityManager(true);
            }
            return xMLSecurityManager;
        }
        if (object instanceof XMLSecurityManager) {
            return (XMLSecurityManager)object;
        }
        if (xMLSecurityManager == null) {
            xMLSecurityManager = new XMLSecurityManager(true);
        }
        if (object instanceof SecurityManager) {
            SecurityManager securityManager = (SecurityManager)object;
            xMLSecurityManager.setLimit(Limit.MAX_OCCUR_NODE_LIMIT, State.APIPROPERTY, securityManager.getMaxOccurNodeLimit());
            xMLSecurityManager.setLimit(Limit.ENTITY_EXPANSION_LIMIT, State.APIPROPERTY, securityManager.getEntityExpansionLimit());
            xMLSecurityManager.setLimit(Limit.ELEMENT_ATTRIBUTE_LIMIT, State.APIPROPERTY, securityManager.getElementAttrLimit());
        }
        return xMLSecurityManager;
    }

    public static enum Limit {
        ENTITY_EXPANSION_LIMIT("EntityExpansionLimit", "http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", "jdk.xml.entityExpansionLimit", 0, 64000, Processor.PARSER),
        MAX_OCCUR_NODE_LIMIT("MaxOccurLimit", "http://www.oracle.com/xml/jaxp/properties/maxOccurLimit", "jdk.xml.maxOccurLimit", 0, 5000, Processor.PARSER),
        ELEMENT_ATTRIBUTE_LIMIT("ElementAttributeLimit", "http://www.oracle.com/xml/jaxp/properties/elementAttributeLimit", "jdk.xml.elementAttributeLimit", 0, 10000, Processor.PARSER),
        TOTAL_ENTITY_SIZE_LIMIT("TotalEntitySizeLimit", "http://www.oracle.com/xml/jaxp/properties/totalEntitySizeLimit", "jdk.xml.totalEntitySizeLimit", 0, 50000000, Processor.PARSER),
        GENERAL_ENTITY_SIZE_LIMIT("MaxEntitySizeLimit", "http://www.oracle.com/xml/jaxp/properties/maxGeneralEntitySizeLimit", "jdk.xml.maxGeneralEntitySizeLimit", 0, 0, Processor.PARSER),
        PARAMETER_ENTITY_SIZE_LIMIT("MaxEntitySizeLimit", "http://www.oracle.com/xml/jaxp/properties/maxParameterEntitySizeLimit", "jdk.xml.maxParameterEntitySizeLimit", 0, 1000000, Processor.PARSER),
        MAX_ELEMENT_DEPTH_LIMIT("MaxElementDepthLimit", "http://www.oracle.com/xml/jaxp/properties/maxElementDepth", "jdk.xml.maxElementDepth", 0, 0, Processor.PARSER),
        MAX_NAME_LIMIT("MaxXMLNameLimit", "http://www.oracle.com/xml/jaxp/properties/maxXMLNameLimit", "jdk.xml.maxXMLNameLimit", 1000, 1000, Processor.PARSER),
        ENTITY_REPLACEMENT_LIMIT("EntityReplacementLimit", "http://www.oracle.com/xml/jaxp/properties/entityReplacementLimit", "jdk.xml.entityReplacementLimit", 0, 3000000, Processor.PARSER),
        XPATH_GROUP_LIMIT("XPathGroupLimit", "jdk.xml.xpathExprGrpLimit", "jdk.xml.xpathExprGrpLimit", 10, 10, Processor.XPATH),
        XPATH_OP_LIMIT("XPathExprOpLimit", "jdk.xml.xpathExprOpLimit", "jdk.xml.xpathExprOpLimit", 100, 100, Processor.XPATH),
        XPATH_TOTALOP_LIMIT("XPathTotalOpLimit", "jdk.xml.xpathTotalOpLimit", "jdk.xml.xpathTotalOpLimit", 10000, 10000, Processor.XPATH);

        final String key;
        final String apiProperty;
        final String systemProperty;
        final int defaultValue;
        final int secureValue;
        final Processor processor;

        private Limit(String string2, String string3, String string4, int n2, int n3, Processor processor) {
            this.key = string2;
            this.apiProperty = string3;
            this.systemProperty = string4;
            this.defaultValue = n2;
            this.secureValue = n3;
            this.processor = processor;
        }

        public boolean equalsAPIPropertyName(String string) {
            return string == null ? false : this.apiProperty.equals(string);
        }

        public boolean equalsSystemPropertyName(String string) {
            return string == null ? false : this.systemProperty.equals(string);
        }

        public String key() {
            return this.key;
        }

        public String apiProperty() {
            return this.apiProperty;
        }

        String systemProperty() {
            return this.systemProperty;
        }

        public int defaultValue() {
            return this.defaultValue;
        }

        public boolean isSupported(Processor processor) {
            return this.processor == processor;
        }

        int secureValue() {
            return this.secureValue;
        }
    }

    public static enum NameMap {
        ENTITY_EXPANSION_LIMIT("jdk.xml.entityExpansionLimit", "entityExpansionLimit"),
        MAX_OCCUR_NODE_LIMIT("jdk.xml.maxOccurLimit", "maxOccurLimit"),
        ELEMENT_ATTRIBUTE_LIMIT("jdk.xml.elementAttributeLimit", "elementAttributeLimit");

        final String newName;
        final String oldName;

        private NameMap(String string2, String string3) {
            this.newName = string2;
            this.oldName = string3;
        }

        String getOldName(String string) {
            if (string.equals(this.newName)) {
                return this.oldName;
            }
            return null;
        }
    }

    public static enum Processor {
        PARSER,
        XPATH;

    }

    public static enum State {
        DEFAULT("default"),
        FSP("FEATURE_SECURE_PROCESSING"),
        JAXPDOTPROPERTIES("jaxp.properties"),
        LEGACY_SYSTEMPROPERTY("legacy system property"),
        SYSTEMPROPERTY("system property"),
        LEGACY_APIPROPERTY("legacy property"),
        APIPROPERTY("property");

        final String literal;

        private State(String string2) {
            this.literal = string2;
        }

        String literal() {
            return this.literal;
        }
    }
}

